package gov.va.genisis2.ts.dto;

import java.io.Serializable;

public class MetaPropertyDTO implements Serializable, Comparable<MetaPropertyDTO> {

	private static final long serialVersionUID = 3843608122864649019L;

	private String propertyName;
	private String propertyUri;
	private String propertyValue;
	private Boolean isMvpPredicate;

	/**
	 * @return the propertyName
	 */
	public String getPropertyName() {
		return propertyName;
	}

	/**
	 * @param propertyName
	 *            the propertyName to set
	 */
	public void setPropertyName(String propertyName) {
		this.propertyName = propertyName;
	}

	/**
	 * @return the propertyUri
	 */
	public String getPropertyUri() {
		return propertyUri;
	}

	/**
	 * @param propertyUri
	 *            the propertyUri to set
	 */
	public void setPropertyUri(String propertyUri) {
		this.propertyUri = propertyUri;
	}

	/**
	 * @return the propertyValue
	 */
	public String getPropertyValue() {
		return propertyValue;
	}

	/**
	 * @param propertyValue
	 *            the propertyValue to set
	 */
	public void setPropertyValue(String propertyValue) {
		this.propertyValue = propertyValue;
	}

	/**
	 * @return the isMvpPredicate
	 */
	public Boolean getIsMvpPredicate() {
		return isMvpPredicate;
	}

	/**
	 * @param isMvpPredicate
	 *            the isMvpPredicate to set
	 */
	public void setIsMvpPredicate(Boolean isMvpPredicate) {
		this.isMvpPredicate = isMvpPredicate;
	}

	/**
	 * sort interOntologyLinks on 'propertyName' attribute
	 */
	public int compareTo(MetaPropertyDTO object) {
		String localPropertyName = (null != object) ? object.getPropertyName() : null;
		return (null != localPropertyName) ? this.propertyName.compareToIgnoreCase(localPropertyName) : -1;
	}
}
